 ; Ŀ
 ;   ~ - put a line break block on the end of a line.                      
 ;   Copyright 2001, 2002, 2006, 2009, 2010 by Rocket Software Ltd.        
 ;   Rocket - the barnacles of software.                                   
 ; 

 ; Ŀ
 ;   Subroutine Wasp - are we in the Model Space Tab, Paper Space, or      
 ;   a viewport in Paper Space?                                            
 ;   Brooks no Arguments.                                                  
 ;   Calls nothing.                                                        
 ;   Returns: 1 - Model space.                                             
 ;            2 - Paper space.                                             
 ;            3 - A Viewport in Paper Space.                               
 ; 
 (DEFUN WASP ()
  (cond ((= (getvar "tilemode") 1) 1)
        ((= (getvar "cvport") 1) 2)
        (t 3)))
 ; Ŀ
 ;   Wasp end.                                                             
 ; 

 ; Ŀ
 ;   Misps: get a scale factor: 1 in PS, Dimscale in MS or a vport.        
 ;   If the global variable Scalps is t the PS scale is also dimscale.     
 ; 
 (DEFUN MISPS (/ scaalf scapa)
  (setq scaalf (getvar "dimscale"))
  (if (= scaalf 0) (setq scaalf 1))  ; if dimscale is zero, make it 1
  (setq scapa (wasp))
  (cond (scalps scaalf)  ; scalps is set so always dimscale
        ((= scapa 1)     ; ms
         scaalf)
        ((= scapa 2)     ; ps
         1)
        ((= scapa 3)     ; viewport in ps
         scaalf)
        (t scaalf)))     ; no idea - use dimscale
 ; Ŀ
 ;   Misps end.                                                            
 ; 

 ; Ŀ
 ;   ~.                                                                    
 ; 
 (DEFUN C:~ ( / *error* snapp blip disc pa enam entt)
  (setvar "cmdecho" 0)
  (command "undo" "mark")
 ; Ŀ
 ;   Load Incend.                                                          
 ; 
  (if (not incend) (load "incend" ()))
 ; Ŀ
 ;   Make a temporary local error handler.                                 
 ; 
  (defun *error* (shk /)
   (setvar "snapmode" snapp)
   (setvar "blipmode" blip)
  (princ))
 ; Ŀ
 ;   Save and reset relevant sysvars.                                      
 ; 
  (setq snapp (getvar "snapmode"))
  (setvar "snapmode" 0)
  (setq blip (getvar "blipmode"))
  (setvar "blipmode" 0)
 ; Ŀ
 ;   Get the scale, depending on which space we are in and other things.   
 ; 
  (setq disc (misps))
 ; Ŀ
 ;   Get a point.                                                          
 ; 
  (if (null (setq pa (getpoint "Line or <Last>: ")))
      (setq pa (getvar "lastpoint")))
 ; Ŀ
 ;   Call Incend to place the block.                                       
 ; 
  (setq enam (incend "linebrk" pa disc))
 ; Ŀ
 ;   Put the block on the layer the line (or similar thing) occupied.      
 ; 
  (setq entt (entget (entlast)))
  (entmod (subst (assoc 8 (entget enam)) (assoc 8 entt) entt))
 ; Ŀ
 ;   Clean up and end.                                                     
 ; 
  (*error* "")
 (princ))